/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class KnifeItem
extends SwordItem {
    private final Multimap<Attribute, AttributeModifier> attributeModifier;

    public KnifeItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
        Multimap attributeMap = this.m_7167_(EquipmentSlot.MAINHAND);
        ImmutableMultimap.Builder modifierBuilder = ImmutableMultimap.builder();
        modifierBuilder.putAll(attributeMap);
        modifierBuilder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier("KnifeMovementSpeedModifier", 0.1, AttributeModifier.Operation.MULTIPLY_BASE));
        modifierBuilder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier("KnifeAttackKnockbackModifier", -0.1, AttributeModifier.Operation.ADDITION));
        this.attributeModifier = modifierBuilder.build();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifier : super.getAttributeModifiers(equipmentSlot, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)"description.pizzacraft.backstab.title").m_130940_(ChatFormatting.RED));
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344)) {
            tooltip.add((Component)Component.m_237115_((String)"description.pizzacraft.backstab.description").m_130940_(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"description.pizzacraft.hold_shift.title").m_130940_(ChatFormatting.BLUE));
        }
    }

    @Mod.EventBusSubscriber(modid="pizzacraft", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class KnifeEvents {
        @SubscribeEvent
        public static void onKnifeBackstab(LivingHurtEvent event) {
            ItemStack stack;
            InteractionHand activeHand;
            LivingEntity victim = event.getEntity();
            Entity attacker = event.getSource().m_7639_();
            if (victim != null && attacker != null && attacker instanceof LivingEntity && KnifeEvents.compareRotations(attacker.f_19859_, victim.f_19859_, 50.0) && (activeHand = ((LivingEntity)attacker).m_7655_()) == InteractionHand.MAIN_HAND && (stack = ((LivingEntity)attacker).m_21120_(activeHand)).m_41720_() instanceof KnifeItem) {
                float newDamage = event.getAmount() * 1.25f;
                event.setAmount(newDamage);
                attacker.f_19853_.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.2f);
                Minecraft.m_91087_().f_91061_.m_107332_((Entity)victim, (ParticleOptions)ParticleTypes.f_123797_, 10);
            }
        }

        public static boolean compareRotations(double yaw1, double yaw2, double maxDiff) {
            maxDiff = Math.abs(maxDiff);
            double d = Math.abs(yaw1 - yaw2) % 360.0;
            double diff = d > 180.0 ? 360.0 - d : d;
            return diff < maxDiff;
        }
    }
}

